const express = require("express");
const router = new express.Router();
const queries = require("./queries");

router.get('/',(req, res) => {
    res.send("Hello Hmrah App")
})
router.get("/users", queries.getUsers);
router.get("/users/:id", queries.getUserById);
router.post("/users", queries.createUser);
router.post("/user/:id", queries.updateUser);
router.post("/user/del/:id", queries.deleteUser);
router.post("/create", queries.createTable);
router.post("/users/rooms", queries.getRooms);
router.get("/allHotels", queries.getAllHotels);

module.exports = router;
