const { con } = require('../db/conn');

const ctPackages = async (name) => {
    try {
        const createTableQuery = `
        CREATE TABLE ${name} (
            id INT AUTO_INCREMENT PRIMARY KEY,
            package_name VARCHAR(50),
            hotel_id INT NOT NULL,
            number_of_rooms INT,
            room_class CHAR(1) NOT NULL,
            number_of_persons INT NOT NULL,
            transport_service_id INT NOT NULL,
            tag JSON,
            rate DECIMAL(10,2) NOT NULL,
            amenities JSON,
            package_description VARCHAR(1000),
            package_state VARCHAR(30) NOT NULL,
            FOREIGN KEY (hotel_id) REFERENCES hotels(id),
            FOREIGN KEY (transport_service_id) REFERENCES transport(id)
        )
    `;

        await con.promise().query(createTableQuery);
        console.log(`Table ${name} Created!`);
    } catch (err) {
        console.log("Error : ", err);
    }
};

module.exports = ctPackages;



// const {getClient} = require('../db/conn')

// const ctPackages = async (name)=>{
//     try{
//         const client=getClient();
//         const createTableQuery = `
        // CREATE TABLE ${name} (
        //     id serial PRIMARY KEY,
        //     hotel_id INTEGER REFERENCES hotels(id) NOT NULL,
        //     number_of_rooms INTEGER,
        //     room_class CHAR(1) NOT NULL,
        //     number_of_persons INTEGER NOT NULL,
        //     transport_service_id INTEGER REFERENCES transport(id) NOT NULL,
        //     tag TEXT[],
        //     rate NUMERIC(10,2) NOT NULL,
        //     amenities TEXT[]
        // )
//     `;

//     await client.query(createTableQuery);
//     console.log(`Table ${name} Created!`);
//     }catch(err)
//     {
//         console.log("Error : ", err);
//     }
// };

// module.exports=ctPackages;