const { con } = require('../db/conn');

const ctHotel = async (name) => {
    try {
        const createTableQuery = `
        CREATE TABLE IF NOT EXISTS ${con.escapeId(name)} (
            id INT AUTO_INCREMENT PRIMARY KEY,
            name VARCHAR(50) NOT NULL,
            address VARCHAR(100) NOT NULL,
            city VARCHAR(100) NOT NULL,
            province VARCHAR(100) NOT NULL,
            focalperson VARCHAR(255) NOT NULL,
            contact VARCHAR(20) NOT NULL,
            email VARCHAR(255) NOT NULL,
            rating INTEGER CHECK (rating >= 1 AND rating <= 5)
        );`;

        await con.promise().query(createTableQuery);
        console.log(`Table ${name} created successfully`);
    } catch (err) {
        console.error('Error:', err);
    }
};

module.exports = ctHotel;


// const { getClient } = require('../db/conn');

// const ctHotel = async (name) => {
//     const client = getClient();
//     try {
//         const createTableQuery = `
//         CREATE TABLE ${name} (
//             id serial PRIMARY KEY,
//             name VARCHAR(50) NOT NULL,
//             address VARCHAR(100) NOT NULL,
//             city VARCHAR(100) NOT NULL,
//             province VARCHAR(100) NOT NULL,
//             focalperson VARCHAR(255) NOT NULL,
//             contact VARCHAR(20) NOT NULL,
//             email VARCHAR(255) NOT NULL,
//             rating INTEGER CHECK (rating >= 1 AND rating <= 5)
//         );`
//         ;

//         await client.query(createTableQuery);
//         console.log(`Table ${name} created successfully`);
//     } catch (err) {
//         console.error('Error:', err);
//     }
// };

// module.exports = ctHotel;